#include <png.h>
#include <allegro.h>
#include <loadpng.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>

typedef struct {
    int x, y, xx, yy;
} Rect;

int cmp(const void *v1, const void *v2) {
    int r = strcmp(*(const char**) v1, *(const char**) v2);
    return r;
}

char **get_file_names(const char* filename, int *size) {
    struct al_ffblk info;
    char *buffer;
    int count    = 0;
    int cur_size = 32;
    int len = strlen(filename);
    char **names;
    
    buffer = (char*)calloc(len+2, 1);
    sprintf(buffer, "%s*", filename);
    if (al_findfirst(buffer, &info, ~0) == 0) {
        names = calloc(cur_size, sizeof(char*));
        
        names[count] = calloc(strlen( info.name ) +1, 1);
        strcpy(names[count], info.name );
        ++count;
        
        while ( al_findnext( &info ) == 0 ) {
            if (count >= cur_size) {
                cur_size *= 2;
                names = realloc(names, cur_size * sizeof( char * ) );
            }
            names[count] = calloc(strlen( info.name ) +1, 1);
            strcpy(names[count], info.name );
            ++count;
        }
    }
    qsort( names, count, sizeof(char*), cmp);    
    free(buffer);
    
    *size = count;    
    return names;
}

int find_miny(BITMAP *bmp) {
    int x, y;    
    
    /* find minY */
    for (y=0; y < bmp->h; ++y) {
        for (x=0; x < bmp->w; ++x) {
            if (geta(getpixel(bmp, x, y)) > 0) {
                return y;
            }
        }
    }
    return 0;
}

int find_maxy(BITMAP *bmp) {
    int x, y;    
    
    /* find maxY */
    for (y=bmp->h-1; y >= 0; --y) {
        for (x=0; x < bmp->w; ++x) {
            if (geta(getpixel(bmp, x, y)) > 0) {
                return y;
            }
        }
    }
    return bmp->h;
}

int find_minx(BITMAP *bmp) {
    int x, y;    
    
    /* find minX */
    
    for (x=0; x < bmp->w; ++x) {
        for (y=0; y < bmp->h; ++y) {
            if (geta(getpixel(bmp, x, y)) > 0) {
                return x;
            }
        }
    }
    return 0;
}

int find_maxx(BITMAP *bmp) {
    int x, y;    
    
    /* find maxX */
    
    for (x=0; x < bmp->w; ++x) {
        for (y=0; y < bmp->h; ++y) {
            if (geta(getpixel(bmp, x, y)) > 0) {
                return x;
            }
        }
    }
    return 0;
}



void find_used_area(BITMAP *bmp, Rect* rect) {
    int minX=0, minY = 0;
    int maxX=bmp->w, maxY=bmp->h;
}

char* get_output_filename(int argc, char** argv) {
    char *buffer;
    int a;
    if (argc == 2) {
        a = strlen(argv[1])+11;
        buffer = (char*) calloc(a, 1);
        sprintf(buffer, "%s_strip.png", argv[1]);
    } else {
        a=0;
        while (argv[1][a] == argv[2][a] && argv[1][a] != 0 && !isdigit(argv[1][a])) {
            ++a;
        }      
        buffer = (char*) calloc(a, 1);
        memcpy(buffer, argv[1], a);
        memcpy(buffer+a, "_strip.png", 11);
    }    
    return buffer;
}

int main(int argc, char **argv) {
    int  free_list = 0;
    int  count;
    int  a,x;
    int  bg;
    int  max_width = 0; 
    int  max_height = 0;
    char **filename_list;
    char *dest_name;
    BITMAP** images;
    BITMAP*  dest;
    
    install_allegro(SYSTEM_NONE, &a, NULL);
    if (argc < 2) {
        printf("Usage: strip <filename-prefix> or strip <filename-list>\n");
        return 1;        
    } else if (argc == 2) {        
        free_list = 1;
        filename_list = get_file_names( argv[1], &count);
        
    } else if (argc > 2) {
        filename_list = &(argv[1]);
    }
    dest_name = get_output_filename(argc, argv);
    //printf("dest: %s\n", dest_name);
    set_color_conversion(COLORCONV_NONE);
    set_color_depth(32);
        
    images = calloc(count, sizeof(BITMAP*));
    for (a=0; a < count; ++a) {
        images[a] = load_png(filename_list[a], NULL);
        if (images[a]) {
            max_width  = MAX(max_width , images[a]->w+2);
            max_height = MAX(max_height, images[a]->h+2);
        }        
    }
    
    bg = getpixel(images[0], 0, 0);
    dest = create_bitmap_ex(32, max_width * count, max_height);
    clear_to_color(dest, bg);
    
    x = 0;
    for (a=0; a < count; ++a) {
        printf("%i\n", a); fflush(stdout);
        blit(images[a], dest, 0, 0, x + (max_width - images[a]->w)/2, (max_height - images[a]->h)/2, images[a]->w, images[a]->h);         
        x += max_width;
    }
    printf("writing %s (%i,%i)\n", dest_name, dest->w, dest->h);
    save_png(dest_name, dest, NULL);
    
    free(dest_name);
    
    for (a=0; a < count; ++a) {
        if (images[a] != NULL) {
            destroy_bitmap(images[a]);
        }
    }
    free(images);
    if (free_list) {
        free(filename_list);
    }
    return 0;
}
END_OF_MAIN()
