
#define ALLEGRO_STATICLINK
#include <allegro.h>
#include <string.h>
#define OPEN 1
#define MARKED 2
#define BLOWN 3

const   int MAP_WIDTH  = 20, MAP_HEIGHT  = 20;
const   int TILE_WIDTH = 20, TILE_HEIGHT = 20;

BITMAP *doubleBuffer;
BITMAP *mapState,       *bombs,         *bombsTmp,     *bombsTmp2;
int     openTiles  = 0,  countBombs = 0, gameOver = 0;
char    map[MAP_HEIGHT * MAP_WIDTH];

void init() {
    int modes[] = {16, 32, 24, 0};
    int a;
    
    allegro_init();
    install_mouse(); 
    install_keyboard();    
    srand(time(NULL));
    for (a=0; a < 3; a++) {
        set_color_depth(modes[a]);
        if (set_gfx_mode(GFX_AUTODETECT, 400, 400, 0, 0) >=0) {
            break;
        }
    }
    if (modes[a] == 0) {
        exit(0);
    }
    doubleBuffer = create_bitmap(SCREEN_W , SCREEN_H);
    mapState     = create_bitmap(MAP_WIDTH, MAP_HEIGHT);
    bombs        = create_bitmap(MAP_WIDTH, MAP_HEIGHT);
    bombsTmp     = create_bitmap(MAP_WIDTH, MAP_HEIGHT);
    bombsTmp2    = create_bitmap(MAP_WIDTH, MAP_HEIGHT);
    
    show_mouse(screen);
    text_mode(-1);
}

void tile(int x, int y, int col) {
    x *= TILE_WIDTH;   
    y *= TILE_HEIGHT;
    rectfill(doubleBuffer, x,y, x+TILE_WIDTH, y+TILE_HEIGHT, col);
    rect(doubleBuffer, x,y, x+TILE_WIDTH-1, y+TILE_HEIGHT-1, makecol(getr(col)/2, getg(col)/2, getb(col)/2));
}

int calcBombs(int x_, int y_) {
    int x, y, value = 0;
    
    for (x=x_ -1; x < x_+2; x++) {
        for (y= y_ -1; y < y_+ 2; y++){
            if (x >=0 && x < MAP_WIDTH && y >=0 && y < MAP_HEIGHT) {
                value += map[x + y *MAP_WIDTH];
            }
        }
    }
    return value;
}

void drawMap() {
    int x, y;
    char* mapP;
    int col;
    int state;
    int bombCount;
    int cols[] = { makecol(128, 128, 128), makecol(64, 64, 64), makecol(0, 200, 0), makecol(200, 0, 0)};
    
    for (y=0; y < MAP_HEIGHT; y++) {
        mapP = &map[y * MAP_WIDTH];
        for (x=0; x < MAP_WIDTH; x++) {
            state = getpixel(mapState, x, y);
            if (gameOver && map[x +y *MAP_WIDTH]) {
                state = BLOWN;
            }
            col = cols[state];
            tile(x,y,col);                        
            
            if (state == OPEN) {
                bombCount = calcBombs(x,y);
                if (bombCount > 0) {
                    textprintf_centre(doubleBuffer, font, x*TILE_WIDTH + TILE_WIDTH/2, y*TILE_HEIGHT +TILE_HEIGHT/2, makecol(255,255,255), "%i", bombCount);
                }
            }            
            mapP++;
        }
    }
}

void createMap() {
    int a, x, y;
    int pos;
    
    countBombs = rand()%50 +20;;
    
    memset(map, 0, MAP_WIDTH * MAP_HEIGHT);
    clear(mapState);
    clear(bombs);
    clear(bombsTmp);
    clear(bombsTmp2);
    
    for (a=0; a < countBombs; a++) {
        pos = rand() % (MAP_WIDTH * MAP_HEIGHT);
        while (map[pos] != 0) {
            pos = rand() % (MAP_WIDTH * MAP_HEIGHT);
        }
        map[pos] = 1;
    }    
    
    for (y = 0; y < MAP_HEIGHT; y++) {
        for (x = 0; x < MAP_WIDTH; x++) {
            if (calcBombs(x,y) != 0) {
                putpixel(bombs, x, y, 10);
            }
        }
    }
    
}

int uncover_(int x_, int y_) {
    int x;
    int y;
    int value = 0;
    
    for (x=x_ -1; x < x_+2; x++) {
        for (y= y_ -1; y < y_+ 2; y++) {
            if (!map[x + y * MAP_WIDTH]) {
                putpixel(bombsTmp2, x, y, 20);
            }   
        }
    }
    return value;
}


void uncover(int x, int y) {   
    int c = calcBombs(x,y);
    if (c == 0) {            
        blit(bombs, bombsTmp, 0, 0, 0, 0, bombs->w, bombs->h);    
        floodfill(bombs, x, y, 20);    
        blit(bombs, bombsTmp2, 0, 0, 0, 0, bombs->w, bombs->h);
        
        for (y=0; y < bombsTmp->h; y++) {
            for (x=0; x < bombsTmp->w; x++) {
                if (getpixel(bombs, x, y) != getpixel(bombsTmp, x, y)) {
                    uncover_(x,y);
                }
            }
        }        
        openTiles = 0;
        for (y = 0; y < MAP_HEIGHT; y++) {
            for (x = 0; x < MAP_WIDTH; x++) {
                if (getpixel(bombsTmp2, x, y) == 20) {
                    putpixel(mapState, x, y, OPEN);
                    openTiles++;
                }
            }
        }
        blit(bombsTmp2, bombs, 0, 0, 0, 0, bombs->w, bombs->h);
    } else {
        putpixel(mapState, x, y, OPEN);
        putpixel(bombs   , x, y, 20);
    }
}

void waitForKey() {
    while (!keypressed());
    while (keypressed()) { 
        readkey();
    }    
}

void title() {
    clear_to_color(doubleBuffer, makecol(0,64,0));
    
    circlefill(doubleBuffer, 200, 300, 100, makecol(10,10,10));
    circlefill(doubleBuffer, 190, 290, 80 , makecol(40,40,40));
    
    rectfill(doubleBuffer, 195, 168, 205, 170, makecol(255,200,200));
    rectfill(doubleBuffer, 195, 170, 198, 180, makecol(210,40,30));
    rectfill(doubleBuffer, 198, 170, 205, 180, makecol(190,20,0));
    rectfill(doubleBuffer, 195, 180, 197, 205, makecol(120,90,20));
    rectfill(doubleBuffer, 197, 180, 205, 205, makecol(90,70,0));
    
    textprintf_centre(doubleBuffer, font, doubleBuffer->w/2, 30, makecol(230, 230, 230), "LexSweeper");
    textprintf_centre(doubleBuffer, font, doubleBuffer->w/2, 90, makecol(230, 230, 230), "Press any key");
    
    scare_mouse();    
    blit(doubleBuffer, screen, 0, 0, 0, 0, doubleBuffer->w, doubleBuffer->h);    
    waitForKey();    
    unscare_mouse();
}

int main(int , char **) {    
    int mouse_down = -1, button = 0;
    int x, y;
    int needsRepaint = 1;
    
    init();    
    while (1) {
        createMap();    
        title();
        
        gameOver    = 0;
        needsRepaint =1;        
        while (!gameOver) {
            if (key[KEY_ESC]) {
                goto quit;
            }            
            x = mouse_x / TILE_WIDTH;
            y = mouse_y / TILE_HEIGHT;
            if (mouse_b) {                
                if (mouse_down == -1) {                    
                    button = mouse_b;
                    mouse_down = x + y* MAP_WIDTH;
                }
            } else {
                if (mouse_down == x + y* MAP_WIDTH) {                
                    if (button & 1) {
                        if (map[x + y * MAP_WIDTH]) {
                            putpixel(mapState, x, y, BLOWN);
                            gameOver = 1;
                        } else {
                            uncover(x,y);
                            gameOver = (openTiles + countBombs >= MAP_WIDTH * MAP_HEIGHT);
                        }
                    } else {
                        putpixel(mapState, x, y, MARKED);
                        putpixel(bombs   , x, y, 30);
                        gameOver = (openTiles + countBombs >= MAP_WIDTH * MAP_HEIGHT);
                    }
                    needsRepaint = 1;
                }
                mouse_down = -1;
            }            
            if (needsRepaint) {
                drawMap();            
                scare_mouse();
                blit(doubleBuffer, screen, 0, 0, 0, 0, doubleBuffer->w, doubleBuffer->h);
                unscare_mouse();                
                needsRepaint = 0;
            }
        }
        scare_mouse();
        for (x =0, y=0; x < doubleBuffer->w; x+=2, y+=2) {
            line(doubleBuffer, x, 0, x, doubleBuffer->h, 0);
            line(doubleBuffer, 0, y, doubleBuffer->w, y, 0);
            blit(doubleBuffer, screen, 0, 0, 0, 0, doubleBuffer->w, doubleBuffer->h);
        }            
        if (openTiles + countBombs < MAP_WIDTH * MAP_HEIGHT) {
            textprintf_centre(doubleBuffer, font, doubleBuffer->w/2, 100, makecol(230, 230,230), "Kaboom!");            
        } else {
            textprintf_centre(doubleBuffer, font, doubleBuffer->w/2, 100, makecol(230, 230,230), "Well done.");            
        }
        textprintf_centre(doubleBuffer, font, doubleBuffer->w/2, 120, makecol(230, 230,230), "Press Any Key");
        blit(doubleBuffer, screen, 0, 0, 0, 0, doubleBuffer->w, doubleBuffer->h);
        waitForKey();
        unscare_mouse();        
    }    
    quit:
    destroy_bitmap(doubleBuffer);
    destroy_bitmap(mapState);
    destroy_bitmap(bombsTmp);
    destroy_bitmap(bombsTmp2);
    destroy_bitmap(bombs);
    return 0;
} END_OF_MAIN();
