/*
 * Decompiled with CFR 0.152.
 */
public class UFO {
    int x;
    int y;
    int destX;
    int destY;
    int maxX;
    int maxY;
    int count;
    int shield;
    boolean hit = false;
    private boolean wantToAttack = true;
    private boolean attackPos = false;
    boolean attacking = false;
    boolean phase = false;
    boolean sound = false;
    boolean bomber = false;
    private static boolean hasBomber = false;

    public UFO(int maxX, int maxY) {
        this.maxX = maxX;
        this.maxY = maxY;
        this.respawn();
    }

    public void respawn() {
        if (this.bomber) {
            hasBomber = false;
        }
        this.count = 0;
        this.hit = false;
        this.wantToAttack = false;
        this.attacking = false;
        this.attackPos = false;
        this.phase = false;
        this.sound = false;
        if (hasBomber) {
            this.bomber = false;
        } else {
            boolean bl = this.bomber = (int)(Math.random() * (double)100) < 25;
        }
        if (this.bomber) {
            hasBomber = true;
            this.x = -100;
            this.y = 20;
            this.destX = this.maxX + 100;
            this.destY = 20;
            this.shield = 5;
        } else {
            this.x = (int)(Math.random() * (double)this.maxX);
            this.y = -40 - (int)(Math.random() * (double)200);
            this.destX = (int)(Math.random() * (double)this.maxX);
            this.destY = (int)(Math.random() * (double)this.maxY / (double)2);
            this.shield = 0;
        }
    }

    public void step(int d) {
        int y_;
        int x_;
        if (this.destX > this.x) {
            x_ = this.x + d;
            if (x_ > this.destX) {
                x_ = this.destX;
            }
            this.x = x_;
        } else {
            x_ = this.x - d;
            if (x_ < this.destX) {
                x_ = this.destX;
            }
            this.x = x_;
        }
        if (this.destY > this.y) {
            y_ = this.y + d;
            if (y_ > this.destY) {
                y_ = this.destY;
            }
            this.y = y_;
        } else {
            y_ = this.y - d;
            if (y_ < this.destY) {
                y_ = this.destY;
            }
            this.y = y_;
        }
        if (this.x == this.destX && this.y == this.destY) {
            this.changeDestination();
        }
        ++this.count;
        if (this.count > 50) {
            this.wantToAttack = true;
        }
    }

    public void changeDestination() {
        if (this.bomber) {
            this.respawn();
        } else if (this.wantToAttack) {
            if (this.attackPos) {
                this.attacking = true;
            } else {
                this.destX = (int)(Math.random() * (double)this.maxX) - 30;
                this.destY = this.maxY / 2 + (int)(Math.random() * (double)50) - 25;
                this.attackPos = true;
                this.sound = true;
            }
        } else {
            this.destX = (int)(Math.random() * (double)this.maxX);
            this.destY = (int)(Math.random() * (double)this.maxY) / 2;
        }
    }
}

