#include <allegro.h>
#include <stdio.h>
#include <time.h>
#include <fmod.h>
#include <fmod_errors.h>

#define WIDTH 640
#define HEIGHT 480

#define START 0
#define INTRO 1
#define CREDITS 2
#define QUIT 3




typedef struct SpriteStruc {
	int x, y;
	BITMAP *img;	
	int x1, y1;
	int state;
	int score;

	void *next;
	void *prev;	
} Sprite;


BITMAP* doubleBuffer;

volatile int timerCounter;



void myTimerHandler(void) {
    timerCounter++;
}
END_OF_FUNCTION(myTimerHandler);



static char loadBuffer[200];
BITMAP *loadGameGraphic(const char* filename) {
	sprintf(loadBuffer, "gfx.dat#%s", filename);
	return load_bitmap(loadBuffer, NULL);	   
}

FSOUND_SAMPLE* loadSound(const char* filename){
	sprintf(loadBuffer, "%s", filename);
	return FSOUND_Sample_Load(FSOUND_FREE , loadBuffer , FSOUND_NORMAL, 0);	
}

FSOUND_SAMPLE* loadSoundLoop(const char* filename){
	sprintf(loadBuffer, "%s", filename);
	return FSOUND_Sample_Load(FSOUND_FREE , loadBuffer , (FSOUND_LOOP_NORMAL | FSOUND_8BITS | FSOUND_MONO) , 0);	
}

void firstTimeInit() {

	static int colorDepths[] = { 16, 15, 24};	
	int a;	
	static PALETTE pal;
	BITMAP *foo = NULL;


	
	allegro_init();		
	srand(time(NULL));	
	
    for (a=0; a < 4; a++) {
        set_color_depth(colorDepths[a]);
        if (set_gfx_mode(GFX_DIRECTX, WIDTH, HEIGHT, 0, 0) >= 0) {
            break;
        }
    }
	
		
	if (a >= 4) {
        allegro_message("Can't set a hicolor or true color display mode.\nUsing windowed mode instead.");
        set_color_depth(16);
        if (set_gfx_mode(GFX_DIRECTX_WIN, WIDTH, HEIGHT, 0, 0) < 0) {
			allegro_message("I'm really sorry. It seems like there's no DirectX installed.\nI'll do my very best to run anyway.\nYou might want to download DirectX from http://www.microsoft.com");	
			if (set_gfx_mode(GFX_SAFE, WIDTH, HEIGHT, 0, 0) < 0) {
				allegro_message("That's absolutly my fault. For some reason I can't set a graphics mode.");	
				exit(0);
			}
        }
    } 
    
    install_keyboard();
    install_timer();    
    install_mouse();


	LOCK_VARIABLE(timerCounter);
    install_int(myTimerHandler, 10);

	if (!FSOUND_Init(44100, 32, FSOUND_INIT_GLOBALFOCUS)) {		
		allegro_message("%s", FMOD_ErrorString(FSOUND_GetError()));
		//printf("%s\n", FMOD_ErrorString(FSOUND_GetError()));
		exit(1);
	}

	foo = load_bitmap("pal.bmp", pal);
	set_palette(pal);
	destroy_bitmap(foo);

    FSOUND_SetSFXMasterVolume(255);


    doubleBuffer = create_bitmap(WIDTH, HEIGHT);     
	
	
	//fontDat = load_datafile("font.dat");	
	//myfont  = fontDat[0].dat;	
	text_mode(-1);	
}   

void intro(void) {
	#define START_TIME 120
	#define START_TIME_MUSIC 140
	#define END_TIME (START_TIME + 380)
	#define SPOT_TIME (END_TIME + 1360)
	
	static char filename[100];
	BITMAP *bg[2];
	BITMAP *ufo;
	BITMAP *speaker;
	BITMAP *head;
    FSOUND_SAMPLE  *uhuSnd    = loadSound("uhuhuhu.mp2");
	FSOUND_SAMPLE  *news      = loadSound("news.mp2");
	int     a,q;
	int     b = 0;
	int     x,y, yOfs,w,h;
	int     samplePlayed = 0;
	int     deltaT;
	int     channel  = -1;
	int     channel2 = -1;

	float fw, fh;

	bg[0] = loadGameGraphic("starfield.tga");
	bg[1] = loadGameGraphic("starfield1.tga");

	
    ufo     = loadGameGraphic("ufo0.tga");
	speaker = loadGameGraphic("speaker.tga");
	head    = loadGameGraphic("head.tga");
	


	fw = 256.0 / 190.0;
	fh = 109.0 / 190.0; 

	a=0;
	timerCounter = 0;
	while (!keypressed()) {		
		if (timerCounter < END_TIME) {		
			if (rand()%100 > 90) {
				yOfs = rand() % 2 -1;			
			} else {
				yOfs = 0;
			}
			rectfill(doubleBuffer,0,HEIGHT-b,WIDTH,HEIGHT,0);
			blit(bg[a], doubleBuffer, 0, b, 0, 0, WIDTH, HEIGHT);
	
			a = timerCounter % 30 > 15 ? 0 : 1;
	
			if (!samplePlayed && timerCounter > START_TIME_MUSIC) {
				channel = FSOUND_PlaySound(FSOUND_FREE, uhuSnd);
				samplePlayed = 1;
			}
	
			if (timerCounter > START_TIME) {
	
				deltaT = MIN(190, (timerCounter - START_TIME)/2);
	
				y = HEIGHT - (deltaT*1.2);
				x = -300+(deltaT*4) ;
	
				//x = MIN(x, 410);
				//y = MAX(y, 284);
	
	
				w= ufo->w - fw * deltaT;
				h= ufo->h - fh * deltaT;
				
				for (q=1; q < 4; q++) {
					for (b=0; b < q; b++) {	
						masked_stretch_blit(ufo, doubleBuffer, 
											0, 0, ufo->w, ufo->h, 
											x + b*(w+10)-(q*(w+10))/2, y+h*(q-1), w, h);
					}
				}			
			}
		} else if (timerCounter < SPOT_TIME) {

			if (channel2 == -1) {
				channel2 = FSOUND_PlaySound(FSOUND_FREE, news);
			}
			
			a = rand() % 40 + 20;
			clear_to_color(doubleBuffer,makecol(a,a,a));
			for (a=0; a < speaker->h; a++) {
				blit(speaker, doubleBuffer, 0, a, 0, a << 1, WIDTH, 1);
			}
			if (timerCounter % 30 > 20) {
				for (a=0; a < speaker->h; a++) {
					blit(head, doubleBuffer, 0, a, 435, 120+(a << 1), head->w, 1);
				}	
			}
		} else {
			
			goto end_of_intro;
			
		}
		
		vsync();
		blit(doubleBuffer, screen,0,0,0,0,WIDTH,HEIGHT);
	}

	if (channel != -1) {
        FSOUND_StopSound(channel);
	}
	if (channel2 != -1) {
        FSOUND_StopSound(channel2);
	}
	end_of_intro:

	for (a=0; a < HEIGHT/2; a+=8) {
		clear_to_color(doubleBuffer,0);
		rectfill(doubleBuffer, 0, a, WIDTH, HEIGHT-a, makecol(0xff,0xff,0xff));
		blit(doubleBuffer, screen,0,0,0,0,WIDTH,HEIGHT);
	}
	clear_to_color(doubleBuffer,0);
	for (a=0; a < WIDTH/2; a+=6) {
		hline(doubleBuffer, 0, HEIGHT/2, WIDTH, 0);
		hline(doubleBuffer, a, HEIGHT/2, WIDTH-a, makecol(0xff,0xff,0xff));
		blit(doubleBuffer, screen,0,0,0,0,WIDTH,HEIGHT);
	}
	clear_to_color(doubleBuffer,0);
	vline(doubleBuffer,WIDTH/2,0,HEIGHT,makecol(0xff,0xff,0xff));
	blit(doubleBuffer, screen,0,0,0,0,WIDTH,HEIGHT);
	rest(10);
	clear_to_color(doubleBuffer,0);
	blit(doubleBuffer, screen,0,0,0,0,WIDTH,HEIGHT);
	rest(300);


	for (a=0; a < 2; a++) {
		destroy_bitmap(bg[a]);
	}

	FSOUND_Sample_Free(uhuSnd);
	
	destroy_bitmap(ufo);
	destroy_bitmap(speaker);
	destroy_bitmap(head);
	
	#undef START_TIME
	#undef START_TIME_MUSIC
	#undef END_TIME
	#undef SPOT_TIME
}


void credits() {
	BITMAP   * bg = loadGameGraphic("starfield.tga");	
	DATAFILE * dat;
	FONT     * small;
	FONT     * big;
	int        a,b;
	int        running;
	int        y = HEIGHT;
	int        y_ = HEIGHT;
	int        white = makecol(233,233,233);
	int        gray  = makecol(180,180,180);

	static char* text[] = {
		"-Coding & Graphics",
		"Lennart Steinke",
		"",
		"",
		"-Voice Talents",
		"Happy",
		"Sakura",
		"",
		"",
		"-Music",
		"Retro",
		"",
		"",
		"-Thanks go to",
		"Madgarden",
		"Eskimoo",
		"Skywise",
		"Golrien",
		"Claymore",
		"Fungus",
		"Happy",
		"-and",
		"Sakura",
		NULL,

	};

    FMUSIC_MODULE *song = FMUSIC_LoadSong("ji_enemy.it");

	dat   = load_datafile("zombie.fnt");
	small = dat[1].dat;
	big   = dat[0].dat;

	FMUSIC_SetMasterVolume(song, 255);
	FMUSIC_PlaySong(song);

	running = TRUE;
	while (running) {
		blit(bg, doubleBuffer, 0, 0, 0, 0, WIDTH, HEIGHT);
		

		y_ = y;
		a  = 0;
		while (y_ < HEIGHT && text[a] != NULL) {
			b = rand()%20 + 220;
			white = makecol(b,b,b);
			b = rand()%20 + 180;
			gray = makecol(b,b,b);

			if (text[a][0] == '-') {
				textprintf(doubleBuffer, small, 40, y_, gray, "%s", &(text[a][1]));
				y_ += text_height(small);
			} else {
				textprintf(doubleBuffer, big , 80, y_, white, "%s", text[a]);
				y_ += text_height(big);
			}
			a++;
		}
		y--;

		blit(doubleBuffer, screen, 0,0,0,0, WIDTH, HEIGHT);

		running = !keypressed() && y_ > -100;
	}
	for (a=255; a > 0; a--) {
		FMUSIC_SetMasterVolume(song, a);
		rest(5);
	}
	FMUSIC_StopSong(song);	
	FMUSIC_FreeSong(song);

	unload_datafile(dat);
	destroy_bitmap(bg);

}

int menu(void) {
	BITMAP * menuScreen;
	BITMAP * cursor;
	
	DATAFILE * dat;
	FONT     * small;
	FONT     * big;

	FSOUND_SAMPLE  *menuBgSnd  = loadSoundLoop("menu.mp2");
	FSOUND_SAMPLE  *menuSelSnd = loadSound("menusel.mp2");

	int selected  =  0;
	int a         =  0;
	int clickedOn = -1;
	int mouseDown =  0;
	int hilite    = -1;
	int channel   =  0;
	int running   = TRUE;
	int bgcol     = makecol(32,32,32);

	#define MENU_ITEM_COUNT 4
	static char* items[MENU_ITEM_COUNT] = {
		"Save The World",
		"Watch Intro",
		"Credits",
		"Exit",
	};

	menuScreen = loadGameGraphic("menu.tga");
	cursor     = loadGameGraphic("cursor.tga");

	dat   = load_datafile("zombie.fnt");
	small = dat[1].dat;
	big   = dat[0].dat;

	clear_keybuf();


	channel = FSOUND_PlaySound(FSOUND_FREE, menuBgSnd);

	timerCounter = 0;

	while (running) {
		if (bgcol == -1) {
			a = rand() % 6 + 32;
			bgcol     = makecol(a,a,a);
		}
		
		clear_to_color(doubleBuffer, bgcol);
		masked_blit(menuScreen, doubleBuffer, 0, 0, 0, 0, WIDTH, HEIGHT);
		
		hilite = (clickedOn != -1) ? clickedOn : ((selected != -1) ? selected : -1);
		for (a=0; a < MENU_ITEM_COUNT; a++) {
			if (a != hilite) {
				textout_centre(doubleBuffer, small, items[a], WIDTH/2, 155 + a* 38, -1);
			} else {
				textout_centre(doubleBuffer, big, items[a], WIDTH/2, 153 + a* 38, -1);
			}
			
		}
		masked_blit(cursor, doubleBuffer, 0, 0, mouse_x, mouse_y, cursor->w, cursor->h);

		if (mouse_x > 130 && mouse_x < 600 && mouse_y > 155 && mouse_y < (155+MENU_ITEM_COUNT*38)) {
			a = (mouse_y - 155) / 38;
			if (a != selected) {
				FSOUND_PlaySound(FSOUND_FREE, menuSelSnd);
				selected = a;
			}
		} else {
			if (selected >= 0) {
				FSOUND_PlaySound(FSOUND_FREE, menuSelSnd);
			}
			selected = -1;
		}

		if (timerCounter > 8) {
			timerCounter = 0;
			bgcol = -1;
		}
				
		blit(doubleBuffer, screen, 0,0,0,0, WIDTH, HEIGHT);

		running = ! keypressed();
		if ((mouse_b & 1) && !mouseDown) {
			mouseDown = TRUE;
			clickedOn = selected;
		} else if (mouseDown && !(mouse_b & 1)) {
			mouseDown = FALSE;
			if (selected == clickedOn) {
				running = FALSE;
			}			
			clickedOn = -1;
		}
	}
    if (key[KEY_ESC]) {
        selected = QUIT;
    }
	FSOUND_StopSound(channel);


	destroy_bitmap(menuScreen);
	destroy_bitmap(cursor);

	FSOUND_Sample_Free(menuBgSnd);

	unload_datafile(dat);

	return selected;
}

void teslaArc(BITMAP *g, int ox, int oy, int x, int y) {
	int segments = rand()%4 + 4;

	static int vertices[8];
	
	float fx = (x-ox) / segments;
	float fy = (y-oy) / segments;

	int lx, ly,nx,ny;
	int a  = rand()%90+130;
	int col = makecol(a,a,a+10);
	

	lx = ox;
	ly = oy;
	nx = 0;
	ny = 0;


	for (a=0; a < segments; a++) {	
		nx = ox + fx*a + (rand() % 60)-30; 
		ny = oy + fy*a + (rand() % 60)-30;
		//line(g, lx, ly, nx, ny, col);
		vertices[0] = lx-2;
		vertices[1] = ly;

		vertices[2] = lx+2;
		vertices[3] = ly;
		
		vertices[4] = nx+2;
		vertices[5] = ny;
		
		vertices[6] = nx-2;
		vertices[7] = ny;
		polygon(g, 4, vertices, col);
		lx = nx;
		ly = ny;
	}
	vertices[0] = lx-2;
	vertices[1] = ly;

	vertices[2] = lx+2;
	vertices[3] = ly;
	
	vertices[4] = x;
	vertices[5] = y;
	
	vertices[6] = x;
	vertices[7] = y;
	polygon(g, 4, vertices, col);
}

void spark(BITMAP *g, int ox, int oy, int x, int y) {
	int segments = rand()%4 + 4;

	
	float fx = (x-ox) / segments;
	float fy = (y-oy) / segments;

	int lx, ly,nx,ny;
	int a  = rand()%90+130;
	int col = makecol(a,a,a+10);
	

	lx = ox;
	ly = oy;
	nx = 0;
	ny = 0;


	for (a=0; a < segments; a++) {	
		nx = ox + fx*a + (rand() % 60)-30; 
		ny = oy + fy*a + (rand() % 60)-30;
		line(g, lx, ly, nx, ny, col);
	}
}


Sprite* createSprite(BITMAP* img) {
	Sprite* spr = calloc(1, sizeof(Sprite));
	int     t  = (rand()%10)+1;
	float   f  = 1.0 /  ((float) t);
	int     w  = img->w * f;
	int     h  = img->h * f;

	spr->img = create_bitmap(w, h);
	stretch_blit(img, spr->img, 0, 0, img->w, img->h, 0, 0, w, h);

	spr->score = t * 100;
	spr->x     = (rand() % (WIDTH+ 2*2)) -w;
	spr->y     = -h - rand()% 60;

	spr->x1    = rand() % (WIDTH-w*2);
	spr->y1    = rand()%290;

	spr->state = 0;

	return spr;
}

Sprite* freeSprite(Sprite *spr) {
	Sprite *prev = spr->prev;
	Sprite *next = spr->next;

	destroy_bitmap(spr->img);
	if (prev != NULL) {
		prev->next = next;
	}
	if (next != NULL) {
		next->prev = prev;
	}
	return next;
}

void game(void) {
	BITMAP *bg;
	BITMAP *console;
	BITMAP *cursor;
	BITMAP *ufo;
	FSOUND_SAMPLE  *start      = loadSound("60s.mp2");
	FSOUND_SAMPLE  *bzzt       = loadSoundLoop("bzzt.mp2");
	FSOUND_SAMPLE  *noenergy   = loadSoundLoop("noenergy.mp2");
	FSOUND_SAMPLE  *tenSec     = loadSound("10secs.mp2");
	FMUSIC_MODULE  *song       = FMUSIC_LoadSong("ji_enemy.it");
	DATAFILE       *dat;
	DATAFILE       *dat2;
	FONT           *small;
	FONT           *big;
	FONT           *ocr;


	Sprite *first = NULL;
	Sprite *last  = NULL;
	Sprite *spr   = NULL;
	Sprite *node  = NULL;
	
	int     saucerCount  = 0;
	int     bzztChannel  = -1;
	int     bzzt2Channel = -1;
	int     
		secChannel   = -1;
	int     running;
	int     arrived = 0;

	int     attackX = -1;
	int     attackY = -1;
	int     score   = 0;
	int     white   = makecol(222,222,222);
	int     black   = makecol(64,64,64);
	int     energy  = 100;
	int     tmpX, tmpY;
	int     comboCount = 0;
	int     comboScore = 0;
	int     displayCombo = 0;
	int     displayTimeOut = 0;
	int     a;
    int     lastT=0;
    int     addSaucer;
    int     resetT = 0;

	

	dat = load_datafile("ocr.fnt");
	ocr = dat[0].dat;
	
	dat2  = load_datafile("zombie.fnt");
	small = dat2[1].dat;
	big   = dat2[0].dat;

	bg      = loadGameGraphic("scene.tga");
	console = loadGameGraphic("console.tga");
	cursor  = loadGameGraphic("cursor2.tga");
	ufo     = loadGameGraphic("ufo0.tga");

	running = TRUE;

	FMUSIC_PlaySong(song);
	FSOUND_PlaySound(FSOUND_FREE, start);
	timerCounter = 0;
    
	while (running) {
		blit(bg, doubleBuffer, 0, 0, 0, 0, WIDTH, HEIGHT);

		
		if (addSaucer > 20 && saucerCount  < (5 + timerCounter / 500)) { //saucerCount <= 8) {
            addSaucer = 0;
			saucerCount++;
			spr = createSprite(ufo);			
			if (first != NULL) {
				node = first;
				while (node != NULL && node->img->w < spr->img->w) {
					node = node->next;
				}
				if (node == NULL) {
					last->next = spr;
					spr->prev  = last;
					last = spr;
				} else {
					if (node == first) {
						spr->next   = first;
						first->prev = spr;
						first = spr;
					} else {					
						if (node->prev) {
							((Sprite*)node->prev)->next = spr;
						}
						spr->prev  = node->prev;
						spr->next  = node;
						node->prev = spr;
					}
				}

			} else {
				first = spr;
				last  = spr;
			}			
		}

		spr  = NULL;
		node = first;
		while (node != NULL) {
			if (node->state %2 ==0) {
				masked_blit(node->img, doubleBuffer,0,0,node->x, node->y, node->img->w, node->img->h);
			}					

			if (attackX >=0 && attackX > node->x && attackX < node->x + node->img->w && attackY > node->y && attackY < node->y + node->img->h) {
				spr = node;
			}
			if (node->state != 0) {			
				tmpX = node->x + node->img->w/2;
				tmpY = node->y + node->img->h/2;
				spark(doubleBuffer, tmpX, tmpY, tmpX, node->y);
				spark(doubleBuffer, tmpX, tmpY, node->x, tmpY);
				spark(doubleBuffer, tmpX, tmpY, node->x+node->img->w, tmpY);
			}
            
            if (timerCounter - lastT >= 1) {
                arrived = 0;
                if (node->x1 > node->x) {
                    node->x++;
                } else if (node->x1 < node->x) {
                    node->x--;
                } else {
                    arrived++;
                }
                if (node->y1 > node->y) {
                    node->y++;
                } else if (node->y1 < node->y) {
                    node->y--;
                } else {
                    arrived++;
                }
                if (arrived == 2) {
                    node->x1 = MID(-node->img->w/2, rand()% WIDTH , WIDTH +node->img->w/2);
                    node->y1 = MID(-node->img->h/2, rand()% HEIGHT, 290);
                }      
                resetT = 1;
            }

			if (node->state > 0) {
				node->state++;				
			}
			if (node->state > 30) {
				if (spr == node) {
					spr = NULL;
				}
				if (node==first) {
					first = node->next;
				}
				if (node==last) {
					last = node->prev;
				}
				node = freeSprite(node);
				saucerCount--;
			} else {
				node= node->next;
			}			
		}
        if (resetT) {
            addSaucer++;
            lastT = timerCounter;
            resetT = 0;
        }
		if (spr != NULL) {

			if (spr->state == 0) {
				// we hit something
				spr->state++;
				score += spr->score;
				comboScore += spr->score;
				comboCount++;
			}			
		} else if (attackX >=0) {
			// Nothing hit, but shooting
			if (comboCount > 4) {
				score += comboScore;
				displayCombo = comboCount;
				displayTimeOut = timerCounter + 250;
			}	  
			comboCount = 0;
			comboScore = 0;
		}

		if (displayCombo > 4) {			
			textprintf_centre(doubleBuffer, ocr, WIDTH/2, HEIGHT/2,0,"%i hit Combo!", displayCombo);
			textprintf_centre(doubleBuffer, ocr, WIDTH/2-1, HEIGHT/2-1,white,"%i hit Combo!", displayCombo);

			if (timerCounter > displayTimeOut) {
				displayCombo = 0;
			}
		}

		if (mouse_b) {
			if (energy > 5) {
				if (bzztChannel==-1) {
					bzztChannel =FSOUND_PlaySound(FSOUND_FREE, bzzt);
				}
				teslaArc(doubleBuffer, 320, 385, mouse_x, mouse_y);
				teslaArc(doubleBuffer, 280, 410, mouse_x, mouse_y);
				teslaArc(doubleBuffer, 345, 400, mouse_x, mouse_y);
	
				energy -= 5;
	
				attackX = mouse_x;
				attackY = mouse_y;
			} else {
				if (bzztChannel !=-1) {
					FSOUND_StopSound(bzztChannel);
				}
				bzztChannel = -1;

				if (bzzt2Channel  == -1) {
					bzzt2Channel = FSOUND_PlaySound(FSOUND_FREE, noenergy);
				}				
			}
		} else {
			if (bzztChannel !=-1) {
				FSOUND_StopSound(bzztChannel);
			}
			if (bzzt2Channel  != -1) {
				FSOUND_StopSound(bzzt2Channel);				
			}
			bzztChannel  = -1;
			bzzt2Channel = -1;
			attackX = -1;
			attackY = -1;

			if (energy < 100) {
				energy++;
			}
		}

		
		//textprintf(doubleBuffer, ocr, 0, 40, white, "Combo: %i", comboCount);
		textprintf(doubleBuffer, ocr, 0, 10, white, "Score: %07i", score);
		a = ((6000-timerCounter) / 100);
		textprintf_right(doubleBuffer, ocr, WIDTH-10, 10, white, "Countdown: %02i", a);
		if (a <= 11 && secChannel == -1) {
			secChannel = FSOUND_PlaySound(FSOUND_FREE, tenSec);
		}
		
		masked_blit(console, doubleBuffer, 0, 0, 0, HEIGHT-console->h, console->w, console->h);

		rectfill(doubleBuffer, WIDTH/2-51, 446, WIDTH/2+51, 456, black);
		rectfill(doubleBuffer, WIDTH/2-50, 447, WIDTH/2-50+energy, 455, white);

		masked_blit(cursor, doubleBuffer, 0, 0, mouse_x-32, mouse_y-32, cursor->w, cursor->h);

		blit(doubleBuffer, screen, 0,0,0,0, WIDTH, HEIGHT);
		running = !keypressed() && (timerCounter < 6000);
	}

	if (comboCount > 4) {
		score += comboScore;
	}

	textprintf_centre(doubleBuffer, big, WIDTH/2  , 201,     0, "Final Score");
	textprintf_centre(doubleBuffer, big, WIDTH/2+1, 201,     0, "Final Score");
	textprintf_centre(doubleBuffer, big, WIDTH/2  , 200, white, "Final Score");
	textprintf_centre(doubleBuffer, big, WIDTH/2  , 241,     0, "%i", score);
	textprintf_centre(doubleBuffer, big, WIDTH/2+1, 241,     0, "%i", score);
	textprintf_centre(doubleBuffer, big, WIDTH/2  , 240, white, "%i", score);
	blit(doubleBuffer, screen, 0,0,0,0, WIDTH, HEIGHT);
	rest(1000);

	FMUSIC_SetMasterVolume(song, 255);
	FMUSIC_PlaySong(song);
	for (a=255; a > 0; a--) {
		FMUSIC_SetMasterVolume(song, a);
		rest(5);
	}
	FMUSIC_StopSong(song);	
	FMUSIC_FreeSong(song);
	rest(500);

	FSOUND_StopSound(secChannel);

	FSOUND_Sample_Free(start);
	FSOUND_Sample_Free(bzzt);
	FSOUND_Sample_Free(noenergy);
	FSOUND_Sample_Free(tenSec);

	unload_datafile(dat);

	destroy_bitmap(ufo);
	destroy_bitmap(bg);
	destroy_bitmap(console);
	destroy_bitmap(cursor);
}

void main(int argc, char **argv) {

	int quit       = 0;
	int selection  = 0;

	firstTimeInit();
	intro();

	while (!quit) {
		selection = menu();
		switch (selection) {
			case START:
				game();
				break;
			case INTRO:
				intro();
				break;
			case CREDITS:
				credits();
				break;
			case QUIT:
				quit = TRUE;
				break;
		}
	}
	
}
END_OF_MAIN();

